/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report;

import java.io.File;
import java.util.Calendar;
import java.util.Vector;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.VerificationUtil;

public final class ReportUtilConstants {
    public static final String XML_REPORT_FILE_PREFIX = "cvucheckreport";
    public static final String XML_REPORT_FILE_EXTN = ".xml";
    public static final String HTML_REPORT_FILE_PREFIX = "cvucheckreport";
    public static final String HTML_REPORT_FILE_EXTN = ".html";
    public static final String TEXT_REPORT_FILE_PREFIX = "cvucheckreport";
    public static final String TEXT_REPORT_FILE_EXTN = ".txt";
    public static final String CVU_REPORT_XSD_FILE_NAME = "cvureport.xsd";
    public static final String FSEP = File.separator;
    public static final int MAX_ALLOWED_XML_REPORTS = 50;
    public static final int MAX_ALLOWED_HTML_REPORTS = 50;
    public static final int MAX_ALLOWED_TEXT_REPORTS = 50;
    public static final String CLUSTERNAME = "CLUSTER_NAME";
    public static final String DATABASE_NAME_LIST = "DATABASE_NAME_LIST";
    public static final String CRSHOME = "CRS_HOME";
    public static final String CRSUSER = "CRS_USER";
    public static final String CLUSTERWARE_VERSION = "CLUSTERWARE_VERSION";
    public static final String OS_PLATFORM = "OS_PLATFORM";

    public static String getCVUXmlReportSchemaURI() throws XmlFilePathException {
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + FSEP + "cvdata" + FSEP + "cvuxmlreport.xsd")).toURI().toString();
        Trace.out((String)("==== CVU report schema file: " + fullpath));
        return fullpath;
    }

    public static String createCvuTextReportFileAtDefaultPath(String filename) throws ClusterException {
        String defaultDir = ReportUtilConstants.getCvuTextReportDefaultDirPath();
        Trace.out((String)("CVU Text report file path: " + defaultDir + FSEP + filename));
        return VerificationUtil.isStringGood(defaultDir) ? defaultDir + FSEP + filename : null;
    }

    public static String getCvuTextReportDefaultDirPath() throws ClusterException {
        String cvhome = VerificationUtil.getCVHome();
        String fullpath = new File(cvhome + "cv" + FSEP + "report" + FSEP + "text").getAbsolutePath();
        Trace.out((String)("CVU Text report directory path: " + fullpath));
        File dir = new File(fullpath);
        if (!dir.exists() || !dir.isDirectory()) {
            Trace.out((String)("CVU Text report directory path Does not exist creating the directory at path: " + fullpath));
            new ClusterCmd().createDirInNode("localnode", fullpath);
        }
        return fullpath;
    }

    public static String createCvuHtmlReportFileAtDefaultPath(String filename) throws ClusterException {
        String defaultDir = ReportUtilConstants.getCvuHtmlReportDefaultDirPath();
        Trace.out((String)("CVU Html report file path: " + defaultDir + FSEP + filename));
        return VerificationUtil.isStringGood(defaultDir) ? defaultDir + FSEP + filename : null;
    }

    public static String getCvuHtmlReportDefaultDirPath() throws ClusterException {
        String cvhome = VerificationUtil.getCVHome();
        String fullpath = new File(cvhome + "cv" + FSEP + "report" + FSEP + "html").getAbsolutePath();
        Trace.out((String)("CVU Html report directory path: " + fullpath));
        File dir = new File(fullpath);
        if (!dir.exists() || !dir.isDirectory()) {
            Trace.out((String)("CVU Html report directory path Does not exist creating the directory at path: " + fullpath));
            new ClusterCmd().createDirInNode("localnode", fullpath);
        }
        return fullpath;
    }

    public static String createCvuXmlReportFileAtDefaultPath(String filename) throws ClusterException {
        String defaultDir = ReportUtilConstants.getCvuXmlReportDefaultDirPath();
        Trace.out((String)("CVU XML report file path: " + defaultDir + FSEP + filename));
        return VerificationUtil.isStringGood(defaultDir) ? defaultDir + FSEP + filename : null;
    }

    public static String getCvuXmlReportDefaultDirPath() throws ClusterException {
        String cvhome = VerificationUtil.getCVHome();
        String fullpath = new File(cvhome + "cv" + FSEP + "report" + FSEP + "xml").getAbsolutePath();
        Trace.out((String)("CVU XML report directory path: " + fullpath));
        File dir = new File(fullpath);
        if (!dir.exists() || !dir.isDirectory()) {
            Trace.out((String)("CVU XML report directory path Does not exist creating the directory at path: " + fullpath));
            new ClusterCmd().createDirInNode("localnode", fullpath);
        }
        return fullpath;
    }

    public static String getCvuBaselineXmlReportDefaultDirPathForRootScript() throws ClusterException {
        String cvhome = VerificationUtil.getCVHome();
        String fullpath = new File(cvhome + "cv" + FSEP + "baseline" + FSEP + "install").getAbsolutePath();
        Trace.out((String)("CVU Baseline XML report directory path: " + fullpath));
        File dir = new File(fullpath);
        if (!dir.exists() || !dir.isDirectory()) {
            Trace.out((String)("CVU XML report directory path Does not exist creating the directory at path: " + fullpath));
            new ClusterCmd().createDirInNode("localnode", fullpath);
        }
        return fullpath;
    }

    public static String getCvuBaselineXmlReportDefaultDirPathForCVUResource() throws ClusterException {
        String cvhome = VerificationUtil.getCVHome();
        String fullpath = new File(cvhome + "cv" + FSEP + "baseline" + FSEP + "cvures").getAbsolutePath();
        Trace.out((String)("CVU Baseline XML report directory path: " + fullpath));
        File dir = new File(fullpath);
        if (!dir.exists() || !dir.isDirectory()) {
            Trace.out((String)("CVU XML report directory path Does not exist creating the directory at path: " + fullpath));
            new ClusterCmd().createDirInNode("localnode", fullpath);
        }
        return fullpath;
    }

    public static String getCvuBaselineXmlReportDefaultDirPathForUsers() throws ClusterException {
        String cvhome = VerificationUtil.getCVHome();
        String fullpath = new File(cvhome + "cv" + FSEP + "baseline" + FSEP + "users").getAbsolutePath();
        Trace.out((String)("CVU Baseline XML report directory path: " + fullpath));
        File dir = new File(fullpath);
        if (!dir.exists() || !dir.isDirectory()) {
            Trace.out((String)("CVU XML report directory path Does not exist creating the directory at path: " + fullpath));
            new ClusterCmd().createDirInNode("localnode", fullpath);
        }
        return fullpath;
    }

    public static enum TargetType {
        SYSTEM_BASED_CHECKS,
        CLUSTER_BASED_CHECKS,
        DATABASE_CHECKS,
        NETWORK_BASED_CHECKS;

    }

    public static enum ReportContext {
        BEST_PRACTICE,
        CVU_COMMAND_LINE_RUN;

    }

    public static enum TaskType {
        MANDATORY_TASK,
        RECCOMENDED_TASK;

    }

    public static class DatabaseDetails {
        private String m_dbName = null;
        private String m_dbVersion = null;
        private String m_dbHome = null;

        DatabaseDetails(String databaseName, String databaseHome, String databaseVersion) {
            this.m_dbName = databaseName;
            this.m_dbHome = databaseHome;
            this.m_dbVersion = databaseVersion;
        }

        public String getDatabaseHome() {
            return this.m_dbHome;
        }

        public String getDatabaseName() {
            return this.m_dbName;
        }

        public String getDatabaseVersion() {
            return this.m_dbVersion;
        }
    }

    public static class BasicClusterWareDetails {
        private String m_clusterName = null;
        private String m_crsHome = null;
        private String m_crsUserName = null;
        private String m_osPlatform = null;
        private String m_clusterwareVersion = null;
        private Vector<DatabaseDetails> m_dbList = null;
        private Calendar m_timeStamp = Calendar.getInstance();

        public BasicClusterWareDetails() {
            this.m_dbList = new Vector();
        }

        public void setClusterName(String clusterName) {
            this.m_clusterName = clusterName;
        }

        public void setClusterwareVersion(String clusterwareVersion) {
            this.m_clusterwareVersion = clusterwareVersion;
        }

        public void setCrsHome(String crsHome) {
            this.m_crsHome = crsHome;
        }

        public void setCrsUserName(String crsUserName) {
            this.m_crsUserName = crsUserName;
        }

        public void setOsPlatform(String osPlatform) {
            this.m_osPlatform = osPlatform;
        }

        public String getClusterName() {
            return this.m_clusterName;
        }

        public String getClusterwareVersion() {
            return this.m_clusterwareVersion;
        }

        public String getCrsHome() {
            return this.m_crsHome;
        }

        public String getCrsUserName() {
            return this.m_crsUserName;
        }

        public String getOsPlatform() {
            return this.m_osPlatform;
        }

        public void addDatabaseDetails(String dbName, String dbHome, String dbVersion) {
            this.m_dbList.add(new DatabaseDetails(dbName, dbHome, dbVersion));
        }

        public int getDatabaseCount() {
            return this.m_dbList.size();
        }

        public Vector<DatabaseDetails> getDatabases() {
            return this.m_dbList;
        }

        public void setTimeStamp(Calendar calendar) {
            this.m_timeStamp = calendar;
        }

        public Calendar getTimeStamp() {
            return this.m_timeStamp;
        }
    }
}

